/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityBean;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.rcs.outconn.ServiceAgreementBean;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OutboundConnectivityTasklet
extends PanelTasklet
implements OutboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSOCTT";
    private static final String TRACE_MASKF = "XRCSOCTF";
    private static final String TRACE_MASKD = "XRCSOCTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-OConTskl");
    private OutboundConnectivityBean outboundConnBean;
    private OutboundConfigData outboundConfigData;
    private static final String DFC_RCSOUTCONFIG_ID = "rcsoutconncfg";
    private static final String METHODS_PREFIX = "methods_";
    private LocalizableText serviceAgreement;
    private static DataRepApp dataRepApp = DataRepApp.getDataRepApp();

    public OutboundConnectivityTasklet() {
        Trace.trace(TRACE_MASKT, "<> OutboundConnectivityTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block19: {
            Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
            try {
                if (request.isInitialRequest()) {
                    this.outboundConnBean = new OutboundConnectivityBean();
                    this.outboundConnBean.setBeanName("OutboundConnectivityBean");
                    OutboundConfigManager outCfgMgr = OutboundConfigManager.getOutboundConfigManager();
                    this.outboundConfigData = outCfgMgr.getOutboundConfig();
                    this.outboundConnBean.setCallHomeServer(this.outboundConfigData.isCallHomeServer());
                    DisplayAreaDescriptorData outConnPanel = new DisplayAreaDescriptorData("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "OutboundConnectivityPanel", this.outboundConnBean, null, null);
                    ArrayList<DisplayAreaDescriptorDelegate> tabDelegates = new ArrayList<DisplayAreaDescriptorDelegate>();
                    try {
                        String configPath = BaseFileControl.getFilePath(DFC_RCSOUTCONFIG_ID);
                        Trace.trace(TRACE_MASKF, "Config path=" + configPath);
                        File[] methodFiles = new File(configPath).listFiles(new MethodsFileFilter());
                        if (methodFiles.length >= 1) {
                            Trace.trace(TRACE_MASKF, "Methods config file=" + methodFiles[0]);
                            ConfigXmlHandler cfgHandler = new ConfigXmlHandler();
                            ConfigData configData = cfgHandler.parseOutConnXML(new FileReader(methodFiles[0]));
                            Iterator methods = configData.methods.iterator();
                            while (methods.hasNext()) {
                                MethodData methodData = (MethodData)methods.next();
                                Trace.trace(TRACE_MASKF, methodData);
                                HashMap<String, PathPlatform> initData = new HashMap<String, PathPlatform>();
                                initData.put("PathPlatform", methodData.createPathPlatform());
                                DisplayAreaDescriptorDelegate tab = new DisplayAreaDescriptorDelegate(methodData.taskletClass, initData);
                                tab.setMountPoint("ConnectivityMethodsTPane");
                                tabDelegates.add(tab);
                            }
                            if (configData.agreementBundle != null) {
                                this.serviceAgreement = new LocalizableText(configData.agreementBundle, configData.agreementKey);
                                this.outboundConnBean.setUseServiceAgreement(true);
                            }
                        } else {
                            String desc = "No outbound connectivity methods configured in " + configPath;
                            Trace.trace(TRACE_MASKF, desc);
                            FrameworkLog fl = new FrameworkLog(classLogInfo, 1936);
                            fl.add(desc);
                            fl.log();
                        }
                    }
                    catch (Exception e) {
                        FrameworkLog fl = new FrameworkLog(classLogInfo, 1936, e);
                        fl.log();
                    }
                    DisplayAreaDescriptor[] tabs = tabDelegates.toArray(new DisplayAreaDescriptorDelegate[tabDelegates.size()]);
                    response.replace(outConnPanel, tabs);
                    break block19;
                }
                if (request.isDisposed() || request.isCanceled()) {
                    response.terminate();
                } else {
                    String source = (String)request.getData("Source");
                    if (source == null) {
                        source = "";
                    }
                    Trace.trace(TRACE_MASKF, "source=" + source);
                    if (source.equals("")) {
                        Trace.trace(TRACE_MASKF, "Unspecified source");
                        response.noAction();
                    } else if (source.equals("OutboundConnectivityPanel")) {
                        this.serviceOutboundConnectivityPanel(request, response);
                    } else if (source.equals("ServiceAgreementPanel")) {
                        this.serviceAgreementPanel(request, response);
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown source");
                        response.noAction();
                    }
                }
            }
            catch (TaskletException te) {
                throw te;
            }
            catch (Exception e) {
                throw new TaskletException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 1940, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    private void serviceOutboundConnectivityPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceOutboundConnectivityPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("OpenServiceAgreementPanel")) {
            ServiceAgreementBean agreementBean = new ServiceAgreementBean();
            agreementBean.setBeanName("ServiceAgreementBean");
            agreementBean.setAgreementText(this.serviceAgreement);
            response.openModalChild("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "ServiceAgreementPanel", agreementBean);
        } else if (command.equals("DisableCallHome")) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("Command", command);
            response.update("OutboundConnectivityBean", data);
        } else if (command.equals("EnableCallHome")) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("Command", command);
            response.update("OutboundConnectivityBean", data);
        } else if (command.equals("Commit")) {
            OutboundConnectivityBean bean = (OutboundConnectivityBean)request.getData("Bean");
            if (bean != null) {
                this.outboundConfigData.setCallHomeServer(bean.isCallHomeServer());
            }
            if (this.outboundConfigData.isCallHomeServer() && !this.outboundConfigData.hasConnectivity()) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("Command", "DisplayMsg");
                data.put("MsgId", "NO_CONNECTIVITY");
                response.update("OutboundConnectivityBean", data);
            } else {
                OutboundConfigManager outCfgMgr = OutboundConfigManager.getOutboundConfigManager();
                outCfgMgr.setOutboundConfig(this.outboundConfigData);
                String sourceDataKey = new OutboundConfigManager.SaveRestore().getCustomDataKey();
                dataRepApp.displayCustDataWarning(sourceDataKey, this);
                response.terminate();
            }
        } else if (command.equals("Cancel")) {
            response.terminate();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceOutboundConnectivityPanel()");
    }

    private void serviceAgreementPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceAgreementPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Accept")) {
            PanelTaskletRequest newRequest = new PanelTaskletRequest();
            newRequest.setData("Source", "OutboundConnectivityPanel");
            newRequest.setData("Command", "EnableCallHome");
            this.postRequest("OutboundConnectivityBean", newRequest);
            response.dispose();
        } else if (command.equals("Decline")) {
            PanelTaskletRequest newRequest = new PanelTaskletRequest();
            newRequest.setData("Source", "OutboundConnectivityPanel");
            newRequest.setData("Command", "DisableCallHome");
            this.postRequest("OutboundConnectivityBean", newRequest);
            response.dispose();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceAgreementPanel()");
    }

    public OutboundConfigData getOutboundConfigData() {
        return this.outboundConfigData;
    }

    class ConfigXmlHandler
    extends DefaultHandler {
        private static final String ELEMENT_OUTBOUND_CONNECTIVITY = "OutboundConnectivity";
        private static final String ELEMENT_SERVICE_AGREEMENT = "ServiceAgreement";
        private static final String ELEMENT_RESOURCE_BUNDLE = "ResourceBundle";
        private static final String ELEMENT_KEY = "Key";
        private static final String ELEMENT_METHOD = "Method";
        private static final String ELEMENT_TASKLET_CLASS = "TaskletClass";
        private static final String ELEMENT_PATH_PLATFORM = "PathPlatform";
        private XMLReader xmlReader = new SAXParser();
        private StringBuffer chars = new StringBuffer();
        private ConfigData configData;
        private MethodData methodData;

        public ConfigXmlHandler() {
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setErrorHandler(this);
        }

        public synchronized ConfigData parseOutConnXML(Reader reader) throws IOException, SAXException {
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
            this.xmlReader.parse(new InputSource(reader));
            return this.configData;
        }

        public void startDocument() throws SAXException {
            this.chars.setLength(0);
            this.configData = new ConfigData();
        }

        public void endDocument() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals(ELEMENT_METHOD)) {
                this.methodData = new MethodData();
            }
            this.chars.setLength(0);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals(ELEMENT_METHOD)) {
                this.configData.methods.add(this.methodData);
            } else if (localName.equals(ELEMENT_TASKLET_CLASS)) {
                this.methodData.taskletClass = this.chars.toString();
            } else if (localName.equals(ELEMENT_PATH_PLATFORM)) {
                this.methodData.pathPlatform = this.chars.toString();
            } else if (localName.equals(ELEMENT_RESOURCE_BUNDLE)) {
                this.configData.agreementBundle = this.chars.toString();
            } else if (localName.equals(ELEMENT_KEY)) {
                this.configData.agreementKey = this.chars.toString();
            }
            this.chars.setLength(0);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.chars.append(ch, start, length);
        }
    }

    class MethodData {
        String taskletClass = null;
        String pathPlatform = null;

        MethodData() {
        }

        public PathPlatform createPathPlatform() {
            if (this.pathPlatform == null || this.pathPlatform.endsWith("GENERIC")) {
                return PathPlatform.GENERIC;
            }
            if (this.pathPlatform.endsWith("PISERIES")) {
                return PathPlatform.PISERIES;
            }
            if (this.pathPlatform.endsWith("STORAGE")) {
                return PathPlatform.STORAGE;
            }
            if (this.pathPlatform.endsWith("ZSERIES")) {
                return PathPlatform.ZSERIES;
            }
            return PathPlatform.GENERIC;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[MethodData: taskletClass=" + this.taskletClass + ", ");
            sb.append("pathPlatform=" + this.pathPlatform + "]");
            return sb.toString();
        }
    }

    class ConfigData {
        String agreementBundle = null;
        String agreementKey = null;
        List methods = new ArrayList();

        ConfigData() {
        }
    }

    class MethodsFileFilter
    implements FilenameFilter {
        MethodsFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(OutboundConnectivityTasklet.METHODS_PREFIX);
        }
    }
}

